@extends('admin.layout')

@section('title', 'Riwayat Absensi')

@section('content')
<div class="page-header">
    <h2>Riwayat Absensi</h2>
</div>

{{-- Info --}}
<div class="card" style="margin-bottom:8px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        💡 <strong>Info Absensi:</strong>
        Periode {{ request('period', 'week') }} |
        Total Hadir: {{ $stats['present_days'] }} hari |
        Terlambat: {{ $stats['late_days'] }} |
        Total Jam: {{ number_format($stats['total_hours'], 2) }} jam
    </p>
</div>

{{-- Filter --}}
<div class="card" style="margin-bottom:16px">
    <form method="get" style="display:flex;gap:8px;align-items:center">
        <select name="period" style="margin:0">
            <option value="week" {{ request('period') == 'week' ? 'selected' : '' }}>Minggu Ini</option>
            <option value="month" {{ request('period') == 'month' ? 'selected' : '' }}>Bulan Ini</option>
            <option value="custom" {{ request('period') == 'custom' ? 'selected' : '' }}>Custom</option>
        </select>

        <input type="date" name="start_date" value="{{ request('start_date') }}">
        <input type="date" name="end_date" value="{{ request('end_date') }}">

        <select name="status">
            <option value="">Semua Status</option>
            <option value="present" {{ request('status') == 'present' ? 'selected' : '' }}>Hadir</option>
            <option value="late" {{ request('status') == 'late' ? 'selected' : '' }}>Terlambat</option>
            <option value="absent" {{ request('status') == 'absent' ? 'selected' : '' }}>Tidak Hadir</option>
        </select>

        <button class="btn btn-secondary" type="submit">🔍 Filter</button>
        {{-- <a href="{{ route('admin.attendance.riwayat') }}" class="btn btn-secondary">Reset</a> --}}
    </form>
</div>

<div style="overflow-x:auto">
<table>
    <thead>
        <tr>
            <th>Tanggal</th>
            <th>Nama</th>
            <th>Status</th>
            <th>Check In</th>
            <th>Check Out</th>
            <th style="text-align:center">Jam Kerja</th>
            <th>Lokasi Masuk</th>
            <th>Lokasi Keluar</th>
            <th>Dokumen</th>
        </tr>
    </thead>
    <tbody>
        @forelse($attendances as $attendance)
        <tr>
            <td>{{ $attendance->date->format('d/m/Y') }}</td>

            <td>
                <strong>{{ $attendance->user->name ?? '-' }}</strong>
                <div style="font-size:12px;color:#6b7280">
                    {{ $attendance->user->email ?? '' }}
                </div>
            </td>

            <td>
                @php
                    $statusStyle = match($attendance->status) {
                        'present' => 'background:#d1fae5;color:#065f46',
                        'late' => 'background:#fef3c7;color:#92400e',
                        'absent' => 'background:#fee2e2;color:#991b1b',
                        default => 'background:#e5e7eb;color:#374151'
                    };
                @endphp
                <span style="font-size:12px;padding:4px 8px;border-radius:6px;{{ $statusStyle }}">
                    {{ strtoupper($attendance->status) }}
                </span>
            </td>

            <td>{{ $attendance->check_in ?? '-' }}</td>
            <td>{{ $attendance->check_out ?? '-' }}</td>

            <td style="text-align:center">
                <span style="font-weight:600;color:#2563eb">
                    {{ number_format($attendance->work_hours ?? 0, 2) }} jam
                </span>
            </td>

            <td>{{ $attendance->check_in_location ?? '-' }}</td>
            <td>{{ $attendance->check_out_location ?? '-' }}</td>

            <td>
                @if($attendance->hasDocument())
                    <a href="{{ $attendance->getDocumentUrl() }}" target="_blank"
                       class="btn btn-secondary" style="padding:4px 8px;font-size:12px">
                        📎 Lihat
                    </a>
                @else
                    -
                @endif
            </td>
        </tr>
        @empty
        <tr>
            <td colspan="9" style="text-align:center;color:#9ca3af">
                Tidak ada data absensi
            </td>
        </tr>
        @endforelse
    </tbody>
</table>
</div>

<div class="pagination">
    {{ $attendances->withQueryString()->links() }}
</div>
@endsection
