<?php $__env->startSection('title', 'Permission Matrix - Role vs Permissions'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Permission Matrix - Role vs Permissions</h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.permissions.index')); ?>" class="btn btn-secondary">📋 All Permissions</a>
        <a href="<?php echo e(route('admin.permissions.capabilities')); ?>" class="btn btn-primary">🎯 Capabilities</a>
    </div>
</div>

<div class="card" style="margin-bottom:16px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        📊 <strong>Permission Matrix:</strong> Tabel ini menampilkan mapping antara role dan permissions dalam format matrix. 
        ✓ = memiliki akses, - = tidak memiliki akses.
    </p>
</div>

<?php $__currentLoopData = $permissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="card" style="margin-bottom:24px">
    <h3 style="margin-bottom:16px;color:#1f2937;display:flex;align-items:center;gap:8px">
        <?php switch($category):
            case ('dashboard'): ?>
                📊 Dashboard Functions
                <?php break; ?>
            <?php case ('users'): ?> 
                👥 User Management
                <?php break; ?>
            <?php case ('roles'): ?>
                🛡️ Role Management
                <?php break; ?>
            <?php case ('attendance'): ?>
                ⏰ Attendance Management
                <?php break; ?>
            <?php case ('shifts'): ?>
                🕐 Shift Management
                <?php break; ?>
            <?php case ('reports'): ?>
                📊 Reports & Analytics
                <?php break; ?>
            <?php case ('complaints'): ?>
                📝 Complaints & Leave
                <?php break; ?>
            <?php case ('profile'): ?>
                👤 Profile Management
                <?php break; ?>
            <?php case ('system'): ?>
                ⚙️ System Administration
                <?php break; ?>
            <?php default: ?>
                📋 <?php echo e(ucfirst($category)); ?>

        <?php endswitch; ?>
        <span style="background:#e5e7eb;color:#374151;padding:4px 8px;border-radius:6px;font-size:12px">
            <?php echo e($categoryPermissions->count()); ?> permissions
        </span>
    </h3>

    <div style="overflow-x:auto">
        <table style="width:100%;min-width:600px">
            <thead>
                <tr>
                    <th style="text-align:left;min-width:250px;padding:12px 8px">Permission</th>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <th style="text-align:center;min-width:80px;padding:12px 8px">
                            <div style="display:flex;flex-direction:column;align-items:center;gap:4px">
                                <?php switch($role->name):
                                    case ('admin'): ?>
                                        <span style="background:#dc2626;color:white;padding:4px 8px;border-radius:6px;font-size:11px">
                                            👑 Admin
                                        </span>
                                        <?php break; ?>
                                    <?php case ('manager'): ?>
                                        <span style="background:#059669;color:white;padding:4px 8px;border-radius:6px;font-size:11px">
                                            👔 Manager
                                        </span>
                                        <?php break; ?>
                                    <?php case ('supervisor'): ?>
                                        <span style="background:#ea580c;color:white;padding:4px 8px;border-radius:6px;font-size:11px">
                                            👨‍💼 Supervisor
                                        </span>
                                        <?php break; ?>
                                    <?php case ('employee'): ?>
                                        <span style="background:#6366f1;color:white;padding:4px 8px;border-radius:6px;font-size:11px">
                                            👤 Employee
                                        </span>
                                        <?php break; ?>
                                    <?php default: ?>
                                        <span style="background:#6b7280;color:white;padding:4px 8px;border-radius:6px;font-size:11px">
                                            <?php echo e($role->display_name ?? ucfirst($role->name)); ?>

                                        </span>
                                <?php endswitch; ?>
                            </div>
                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $categoryPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr style="border-top:1px solid #e5e7eb">
                    <td style="padding:12px 8px;vertical-align:top">
                        <div>
                            <strong style="font-size:13px;color:#1f2937"><?php echo e($permission->display_name); ?></strong>
                            <?php if($permission->description): ?>
                                <div style="font-size:11px;color:#6b7280;margin-top:2px;line-height:1.4">
                                    <?php echo e(Str::limit($permission->description, 80)); ?>

                                </div>
                            <?php endif; ?>
                            <code style="font-size:10px;background:#f3f4f6;padding:1px 4px;border-radius:3px;color:#6b7280;margin-top:4px;display:inline-block">
                                <?php echo e($permission->name); ?>

                            </code>
                        </div>
                    </td>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td style="text-align:center;padding:12px 8px;vertical-align:middle">
                            <?php if($role->hasPermission($permission)): ?>
                                <span style="color:#059669;font-size:16px;font-weight:bold" title="<?php echo e($role->display_name ?? ucfirst($role->name)); ?> has this permission">✓</span>
                            <?php else: ?>
                                <span style="color:#d1d5db;font-size:16px" title="<?php echo e($role->display_name ?? ucfirst($role->name)); ?> does not have this permission">-</span>
                            <?php endif; ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Summary Statistics -->
<div class="card" style="background:#f9fafb">
    <h3 style="margin-bottom:16px">📊 Ringkasan Matrix</h3>
    
    <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:16px">
        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="text-align:center;padding:16px;background:white;border-radius:8px;border-left:4px solid #<?php echo e($role->name === 'admin' ? 'dc2626' : ($role->name === 'manager' ? '059669' : ($role->name === 'supervisor' ? 'ea580c' : '6366f1'))); ?>">
                <div style="font-weight:600;margin-bottom:4px"><?php echo e($role->display_name ?? ucfirst($role->name)); ?></div>
                <div style="font-size:24px;font-weight:bold;color:#<?php echo e($role->name === 'admin' ? 'dc2626' : ($role->name === 'manager' ? '059669' : ($role->name === 'supervisor' ? 'ea580c' : '6366f1'))); ?>">
                    <?php echo e($role->permissions->count()); ?>

                </div>
                <div style="font-size:12px;color:#6b7280">
                    permissions (<?php echo e(number_format(($role->permissions->count() / $permissions->count()) * 100, 1)); ?>%)
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>

<style>
table {
    border-collapse: collapse;
}

table th, table td {
    border: 1px solid #e5e7eb;
}

table th {
    background: #f9fafb;
    font-weight: 600;
    color: #374151;
}

table tbody tr:hover {
    background: #f9fafb;
}

@media (max-width: 768px) {
    .page-header {
        flex-direction: column;
        align-items: flex-start;
        gap: 12px;
    }
    
    .actions {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\absen-dutacom\resources\views/admin/permissions/matrix.blade.php ENDPATH**/ ?>