<?php $__env->startSection('title', 'Detail Role: ' . $role->display_name); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Detail Role: <?php echo e($role->display_name); ?></h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.roles.index')); ?>" class="btn btn-secondary">← Kembali</a>
        <a href="<?php echo e(route('admin.roles.edit', $role)); ?>" class="btn btn-warning">✏️ Edit</a>
    </div>
</div>

<?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="alert alert-error">
        <ul style="margin:0;padding-left:20px">
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<div class="row" style="display:grid;grid-template-columns:1fr 2fr;gap:16px;margin-bottom:16px">
    <!-- Role Info -->
    <div class="card">
        <h3 style="margin-bottom:16px">Informasi Role</h3>
        
        <div style="margin-bottom:12px">
            <strong style="color:#374151">Nama Role:</strong><br>
            <span style="font-family:monospace;background:#f3f4f6;padding:2px 6px;border-radius:4px;font-size:14px"><?php echo e($role->name); ?></span>
        </div>

        <div style="margin-bottom:12px">
            <strong style="color:#374151">Nama Tampilan:</strong><br>
            <span style="font-size:16px;font-weight:600"><?php echo e($role->display_name); ?></span>
        </div>

        <div style="margin-bottom:12px">
            <strong style="color:#374151">Deskripsi:</strong><br>
            <span style="color:#6b7280"><?php echo e($role->description ?: 'Tidak ada deskripsi'); ?></span>
        </div>

        <div style="margin-bottom:12px">
            <strong style="color:#374151">Jumlah User:</strong><br>
            <span style="font-size:18px;font-weight:600;color:#0ea5e9"><?php echo e($role->users->count()); ?> user</span>
        </div>

        <div style="margin-bottom:12px">
            <strong style="color:#374151">Jumlah Permissions:</strong><br>
            <span style="font-size:16px;font-weight:600;color:#059669"><?php echo e($role->permissions->count()); ?> permissions</span>
        </div>

        <?php
            $systemRoles = ['admin', 'manager', 'employee', 'supervisor'];
            $isSystem = in_array($role->name, $systemRoles);
        ?>

        <div style="margin-bottom:12px">
            <strong style="color:#374151">Tipe:</strong><br>
            <?php if($isSystem): ?>
                <span style="background:#f3f4f6;color:#374151;padding:4px 8px;border-radius:6px;font-size:12px;font-weight:500">
                    🔒 Role Sistem
                </span>
            <?php else: ?>
                <span style="background:#dcfce7;color:#166534;padding:4px 8px;border-radius:6px;font-size:12px;font-weight:500">
                    ✨ Role Custom
                </span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Users with this role -->
    <div class="card">
        <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:16px">
            <h3 style="margin:0">User dengan Role Ini</h3>
            <?php if($role->users->count() > 0): ?>
                <span style="background:#e0e7ff;color:#3730a3;padding:4px 8px;border-radius:6px;font-size:12px;font-weight:500">
                    <?php echo e($role->users->count()); ?> user
                </span>
            <?php endif; ?>
        </div>

        <?php if($role->users->count() > 0): ?>
            <div style="overflow-x:auto">
                <table style="margin-bottom:0">
                    <thead>
                        <tr>
                            <th>ID Card</th>
                            <th>Nama</th>
                            <th>Email</th>
                            <th>Role Lain</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $role->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <span style="font-weight:600;color:#0ea5e9"><?php echo e($user->employee_id ?: '-'); ?></span>
                            </td>
                            <td><strong><?php echo e($user->name); ?></strong></td>
                            <td><?php echo e($user->email); ?></td>
                            <td>
                                <?php
                                    $otherRoles = $user->roles->where('id', '!=', $role->id);
                                ?>
                                <?php if($otherRoles->count() > 0): ?>
                                    <?php $__currentLoopData = $otherRoles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $otherRole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span style="background:#f3f4f6;color:#374151;padding:2px 6px;border-radius:4px;font-size:11px;margin-right:4px">
                                            <?php echo e($otherRole->display_name); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span style="color:#9ca3af">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <form method="POST" action="<?php echo e(route('admin.roles.remove-user', [$role, $user])); ?>" style="display:inline" 
                                    onsubmit="return confirm('Yakin ingin menghapus <?php echo e($user->name); ?> dari role <?php echo e($role->display_name); ?>?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-danger" title="Hapus dari role">🗑️</button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div style="text-align:center;padding:40px;color:#6b7280;background:#f9fafb;border-radius:8px">
                👤 Belum ada user dengan role ini
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add Users to Role -->
<?php if($role->users->count() < \App\Models\User::count()): ?>
<div class="card">
    <h3 style="margin-bottom:16px">Tambah User ke Role</h3>
    
    <form method="POST" action="<?php echo e(route('admin.roles.assign-users', $role)); ?>">
        <?php echo csrf_field(); ?>
        
        <div class="form-group">
            <label>Pilih User untuk ditambahkan ke role <strong><?php echo e($role->display_name); ?></strong>:</label>
            
            <?php
                $availableUsers = \App\Models\User::whereNotIn('id', $role->users->pluck('id'))->orderBy('name')->get();
            ?>
            
            <?php if($availableUsers->count() > 0): ?>
                <div style="max-height:200px;overflow-y:auto;border:1px solid #d1d5db;border-radius:6px;padding:8px;background:#f9fafb">
                    <?php $__currentLoopData = $availableUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="margin-bottom:8px">
                        <label style="display:flex;align-items:center;gap:8px;cursor:pointer;padding:4px;border-radius:4px" 
                               onmouseover="this.style.background='#e5e7eb'" onmouseout="this.style.background='transparent'">
                            <input type="checkbox" name="user_ids[]" value="<?php echo e($user->id); ?>">
                            <div style="flex:1">
                                <strong><?php echo e($user->name); ?></strong> 
                                <span style="color:#6b7280">(<?php echo e($user->email); ?>)</span>
                                <?php if($user->employee_id): ?>
                                    <span style="color:#0ea5e9;font-weight:500"><?php echo e($user->employee_id); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if($user->roles->count() > 0): ?>
                                <div style="font-size:11px">
                                    <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userRole): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span style="background:#e5e7eb;color:#374151;padding:1px 4px;border-radius:3px;margin-left:2px">
                                            <?php echo e($userRole->display_name); ?>

                                        </span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </label>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                
                <div style="margin-top:16px">
                    <button type="submit" class="btn btn-primary">➕ Tambahkan User Terpilih</button>
                </div>
            <?php else: ?>
                <div style="text-align:center;padding:20px;color:#6b7280;background:#f9fafb;border-radius:8px">
                    ✅ Semua user sudah memiliki role ini
                </div>
            <?php endif; ?>
        </div>
    </form>
</div>
<?php endif; ?>

<!-- Manage Role Permissions -->
<div class="card">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:16px">
        <h3 style="margin:0">Kelola Permissions Role</h3>
        <button onclick="togglePermissionManager()" class="btn btn-primary" id="togglePermissionBtn">
            ⚙️ Atur Permissions
        </button>
    </div>
    
    <div id="permissionManager" style="display:none;margin-bottom:24px;padding:16px;background:#f9fafb;border-radius:8px;border-left:4px solid #0ea5e9">
        <h4 style="margin:0 0 16px 0;color:#1f2937">Assign/Remove Permissions</h4>
        
        <?php
            $allPermissions = \App\Models\Permission::orderBy('category')->orderBy('name')->get();
            $allPermissionsByCategory = $allPermissions->groupBy('category');
        ?>
        
        <form method="POST" action="<?php echo e(route('admin.roles.update-permissions', $role)); ?>" id="permissionForm">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            
            <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));gap:16px;margin-bottom:16px">
                <?php $__currentLoopData = $allPermissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div style="background:white;border-radius:8px;padding:16px;border:1px solid #e5e7eb">
                        <div style="display:flex;align-items:center;justify-content:space-between;margin-bottom:12px">
                            <h5 style="margin:0;color:#1f2937;display:flex;align-items:center;gap:8px">
                                <?php switch($category):
                                    case ('dashboard'): ?> 📊 Dashboard <?php break; ?>
                                    <?php case ('users'): ?> 👥 User Management <?php break; ?>
                                    <?php case ('roles'): ?> 🛡️ Role Management <?php break; ?>
                                    <?php case ('attendance'): ?> ⏰ Attendance <?php break; ?>
                                    <?php case ('shifts'): ?> 🕐 Shifts <?php break; ?>
                                    <?php case ('reports'): ?> 📊 Reports <?php break; ?>
                                    <?php case ('complaints'): ?> 📝 Complaints <?php break; ?>
                                    <?php case ('profile'): ?> 👤 Profile <?php break; ?>
                                    <?php case ('system'): ?> ⚙️ System <?php break; ?>
                                    <?php default: ?> 📋 <?php echo e(ucfirst($category)); ?>

                                <?php endswitch; ?>
                            </h5>
                            <div>
                                <button type="button" onclick="selectAllInCategory('<?php echo e($category); ?>')" 
                                        class="btn btn-sm" style="font-size:10px;padding:2px 6px">All</button>
                                <button type="button" onclick="deselectAllInCategory('<?php echo e($category); ?>')" 
                                        class="btn btn-sm btn-secondary" style="font-size:10px;padding:2px 6px">None</button>
                            </div>
                        </div>
                        
                        <?php $__currentLoopData = $categoryPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="margin-bottom:8px">
                                <label style="display:flex;align-items:flex-start;gap:8px;cursor:pointer;padding:4px;border-radius:4px" 
                                       class="permission-item" data-category="<?php echo e($category); ?>"
                                       onmouseover="this.style.background='#f3f4f6'" 
                                       onmouseout="this.style.background='transparent'">
                                    <input type="checkbox" 
                                           name="permissions[]" 
                                           value="<?php echo e($permission->id); ?>" 
                                           <?php echo e($role->hasPermission($permission) ? 'checked' : ''); ?>

                                           style="margin-top:2px">
                                    <div style="flex:1">
                                        <div style="font-size:12px;font-weight:500;color:#374151">
                                            <?php echo e($permission->display_name); ?>

                                        </div>
                                        <?php if($permission->description): ?>
                                            <div style="font-size:10px;color:#6b7280;margin-top:1px">
                                                <?php echo e(Str::limit($permission->description, 60)); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div style="display:flex;gap:8px;justify-content:flex-end;padding-top:16px;border-top:1px solid #e5e7eb">
                <button type="button" onclick="selectAllPermissions()" class="btn btn-secondary">
                    ✓ Select All
                </button>
                <button type="button" onclick="deselectAllPermissions()" class="btn btn-secondary">
                    ✗ Deselect All
                </button>
                <button type="submit" class="btn btn-primary">
                    💾 Update Permissions
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Role Permissions Display -->
<div class="card">
    <h3 style="margin-bottom:16px">Current Permissions / Hak Akses Role</h3>
    
    <?php if($role->permissions->count() > 0): ?>
        <?php
            $permissionsByCategory = $role->permissions->groupBy('category');
        ?>
        
        <div style="display:grid;grid-template-columns:repeat(auto-fit, minmax(300px, 1fr));gap:16px">
            <?php $__currentLoopData = $permissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $permissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div style="background:#f9fafb;border-radius:8px;padding:16px;border-left:4px solid #0ea5e9">
                    <h4 style="margin:0 0 12px 0;color:#1f2937;text-transform:capitalize;display:flex;align-items:center;gap:8px">
                        <?php switch($category):
                            case ('dashboard'): ?>
                                📊 Dashboard
                                <?php break; ?>
                            <?php case ('users'): ?> 
                                👥 User Management
                                <?php break; ?>
                            <?php case ('roles'): ?>
                                🛡️ Role Management
                                <?php break; ?>
                            <?php case ('attendance'): ?>
                                ⏰ Attendance
                                <?php break; ?>
                            <?php case ('shifts'): ?>
                                🕐 Shifts
                                <?php break; ?>
                            <?php case ('reports'): ?>
                                📊 Reports
                                <?php break; ?>
                            <?php case ('complaints'): ?>
                                📝 Complaints/Leave
                                <?php break; ?>
                            <?php case ('profile'): ?>
                                👤 Profile
                                <?php break; ?>
                            <?php case ('system'): ?>
                                ⚙️ System
                                <?php break; ?>
                            <?php default: ?>
                                📋 <?php echo e(ucfirst($category)); ?>

                        <?php endswitch; ?>
                    </h4>
                    
                    <div>
                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="margin-bottom:8px;display:flex;align-items:center;gap:8px">
                                <span style="color:#059669;font-size:12px">✓</span>
                                <div>
                                    <strong style="font-size:13px;color:#374151"><?php echo e($permission->display_name); ?></strong>
                                    <?php if($permission->description): ?>
                                        <div style="font-size:11px;color:#6b7280;margin-top:2px">
                                            <?php echo e($permission->description); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        
        <div style="margin-top:16px;padding:12px;background:#f0f9ff;border-radius:6px;border-left:4px solid #0ea5e9">
            <p style="margin:0;font-size:13px;color:#0c4a6e">
                💡 <strong>Total:</strong> Role ini memiliki <strong><?php echo e($role->permissions->count()); ?> permissions</strong> 
                yang terbagi dalam <strong><?php echo e($permissionsByCategory->count()); ?> kategori</strong>
            </p>
        </div>
    <?php else: ?>
        <div style="text-align:center;padding:40px;color:#6b7280;background:#f9fafb;border-radius:8px">
            🔒 Role ini belum memiliki permissions yang diberikan
        </div>
    <?php endif; ?>
</div>

<style>
.btn-sm {
    padding: 4px 8px;
    font-size: 12px;
    min-width: 32px;
    text-align: center;
}

.row {
    margin-bottom: 16px;
}

@media (max-width: 768px) {
    .row {
        grid-template-columns: 1fr !important;
    }
}
</style>

<script>
function togglePermissionManager() {
    const manager = document.getElementById('permissionManager');
    const btn = document.getElementById('togglePermissionBtn');
    
    if (manager.style.display === 'none') {
        manager.style.display = 'block';
        btn.innerHTML = '❌ Tutup Pengaturan';
        btn.className = 'btn btn-secondary';
    } else {
        manager.style.display = 'none';
        btn.innerHTML = '⚙️ Atur Permissions';
        btn.className = 'btn btn-primary';
    }
}

function selectAllInCategory(category) {
    const checkboxes = document.querySelectorAll(`.permission-item[data-category="${category}"] input[type="checkbox"]`);
    checkboxes.forEach(checkbox => checkbox.checked = true);
}

function deselectAllInCategory(category) {
    const checkboxes = document.querySelectorAll(`.permission-item[data-category="${category}"] input[type="checkbox"]`);
    checkboxes.forEach(checkbox => checkbox.checked = false);
}

function selectAllPermissions() {
    const checkboxes = document.querySelectorAll('#permissionForm input[type="checkbox"]');
    checkboxes.forEach(checkbox => checkbox.checked = true);
}

function deselectAllPermissions() {
    const checkboxes = document.querySelectorAll('#permissionForm input[type="checkbox"]');
    checkboxes.forEach(checkbox => checkbox.checked = false);
}

// Auto-submit confirmation
document.getElementById('permissionForm').addEventListener('submit', function(e) {
    const checkedBoxes = document.querySelectorAll('#permissionForm input[type="checkbox"]:checked');
    const roleName = '<?php echo e($role->display_name ?? $role->name); ?>';
    
    if (!confirm(`Yakin ingin mengupdate permissions untuk role ${roleName}?\n\nPermissions terpilih: ${checkedBoxes.length} permissions`)) {
        e.preventDefault();
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\absen-dutacom\resources\views/admin/roles/show.blade.php ENDPATH**/ ?>