<?php $__env->startSection('title', 'Fungsi & Hak Akses System'); ?>

<?php $__env->startSection('content'); ?>
<div class="page-header">
    <h2>Fungsi & Hak Akses System</h2>
    <div class="actions">
        <a href="<?php echo e(route('admin.permissions.matrix')); ?>" class="btn btn-secondary">📊 Matrix View</a>
        <a href="<?php echo e(route('admin.permissions.capabilities')); ?>" class="btn btn-primary">🎯 Capabilities</a>
    </div>
</div>

<div class="card" style="margin-bottom:16px;padding:12px;background:#f0f9ff;border-left:4px solid #0ea5e9">
    <p style="margin:0;font-size:13px;color:#0c4a6e">
        📋 <strong>Info:</strong> Halaman ini menampilkan semua fungsi yang tersedia dalam sistem dan role mana saja yang memiliki akses.
    </p>
</div>

<div class="stats-grid" style="display:grid;grid-template-columns:repeat(auto-fit, minmax(200px, 1fr));gap:16px;margin-bottom:24px">
    <div class="stat-card" style="background:#f0fdf4;border-left:4px solid #22c55e;padding:16px;border-radius:8px">
        <div style="font-size:24px;font-weight:bold;color:#15803d"><?php echo e($permissions->count()); ?></div>
        <div style="color:#166534;font-size:14px">Total Permissions</div>
    </div>
    <div class="stat-card" style="background:#fef3c7;border-left:4px solid #f59e0b;padding:16px;border-radius:8px">
        <div style="font-size:24px;font-weight:bold;color:#d97706"><?php echo e($permissionsByCategory->count()); ?></div>
        <div style="color:#92400e;font-size:14px">Kategori</div>
    </div>
    <div class="stat-card" style="background:#e0e7ff;border-left:4px solid #6366f1;padding:16px;border-radius:8px">
        <div style="font-size:24px;font-weight:bold;color:#4f46e5"><?php echo e($permissions->where('is_system', true)->count()); ?></div>
        <div style="color:#3730a3;font-size:14px">System Permissions</div>
    </div>
    <div class="stat-card" style="background:#fce7f3;border-left:4px solid #ec4899;padding:16px;border-radius:8px">
        <div style="font-size:24px;font-weight:bold;color:#be185d"><?php echo e($permissions->where('is_system', false)->count()); ?></div>
        <div style="color:#9d174d;font-size:14px">Custom Permissions</div>
    </div>
</div>

<?php $__currentLoopData = $permissionsByCategory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category => $categoryPermissions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="card" style="margin-bottom:20px">
    <div style="display:flex;align-items:center;gap:12px;margin-bottom:16px;padding-bottom:12px;border-bottom:2px solid #f3f4f6">
        <h3 style="margin:0;color:#1f2937;display:flex;align-items:center;gap:8px">
            <?php switch($category):
                case ('dashboard'): ?>
                    📊 Dashboard Functions
                    <?php break; ?>
                <?php case ('users'): ?> 
                    👥 User Management
                    <?php break; ?>
                <?php case ('roles'): ?>
                    🛡️ Role Management
                    <?php break; ?>
                <?php case ('attendance'): ?>
                    ⏰ Attendance Management
                    <?php break; ?>
                <?php case ('shifts'): ?>
                    🕐 Shift Management
                    <?php break; ?>
                <?php case ('reports'): ?>
                    📊 Reports & Analytics
                    <?php break; ?>
                <?php case ('complaints'): ?>
                    📝 Complaints & Leave
                    <?php break; ?>
                <?php case ('profile'): ?>
                    👤 Profile Management
                    <?php break; ?>
                <?php case ('system'): ?>
                    ⚙️ System Administration
                    <?php break; ?>
                <?php default: ?>
                    📋 <?php echo e(ucfirst($category)); ?>

            <?php endswitch; ?>
        </h3>
        <span style="background:#e5e7eb;color:#374151;padding:4px 8px;border-radius:6px;font-size:12px;font-weight:500">
            <?php echo e($categoryPermissions->count()); ?> permissions
        </span>
    </div>

    <div style="display:grid;grid-template-columns:repeat(auto-fill, minmax(320px, 1fr));gap:12px">
        <?php $__currentLoopData = $categoryPermissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div style="border:1px solid #e5e7eb;border-radius:8px;padding:12px;background:#fafafa">
                <div style="display:flex;justify-content:space-between;align-items:flex-start;margin-bottom:8px">
                    <div style="flex:1">
                        <h4 style="margin:0 0 4px 0;font-size:14px;font-weight:600;color:#1f2937">
                            <?php echo e($permission->display_name); ?>

                        </h4>
                        <code style="font-size:11px;background:#f3f4f6;padding:2px 4px;border-radius:3px;color:#6b7280">
                            <?php echo e($permission->name); ?>

                        </code>
                    </div>
                    <?php if($permission->is_system): ?>
                        <span style="background:#ddd6fe;color:#5b21b6;padding:2px 6px;border-radius:4px;font-size:10px;font-weight:500">
                            System
                        </span>
                    <?php endif; ?>
                </div>

                <?php if($permission->description): ?>
                    <p style="margin:0 0 8px 0;font-size:12px;color:#6b7280;line-height:1.4">
                        <?php echo e($permission->description); ?>

                    </p>
                <?php endif; ?>

                <div style="margin-top:8px">
                    <strong style="font-size:11px;color:#374151">Roles yang memiliki akses:</strong>
                    <div style="margin-top:4px;display:flex;flex-wrap:wrap;gap:4px">
                        <?php $__empty_1 = true; $__currentLoopData = $permission->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <span style="background:#<?php echo e($role->name === 'admin' ? 'dc2626' : ($role->name === 'manager' ? '059669' : ($role->name === 'supervisor' ? 'ea580c' : '6366f1'))); ?>;color:white;padding:2px 6px;border-radius:4px;font-size:10px;font-weight:500">
                                <?php echo e($role->display_name ?? ucfirst($role->name)); ?>

                            </span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span style="color:#9ca3af;font-size:11px;font-style:italic">Tidak ada role</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<style>
.stats-grid {
    margin-bottom: 24px;
}

.stat-card {
    text-align: center;
}

@media (max-width: 768px) {
    .stats-grid {
        grid-template-columns: repeat(2, 1fr);
    }
    
    .actions {
        flex-direction: column;
        gap: 8px;
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\absen-dutacom\resources\views/admin/permissions/index.blade.php ENDPATH**/ ?>